//=============================================================================
// ColsMenuStatus.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 多人数パーティ向けメニューステータス
 * @author まっつＵＰ
 * 
 * @param tpgauge
 * @desc 0でない場合はTPゲージを描画します。
 * @default 0
 *
 * @help
 * 
 * RPGで笑顔を・・・
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * tpgaugeに0以外を入れるとTPゲージをMPゲージの下に描画します。
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

(function() {
    
    var parameters = PluginManager.parameters('ColsMenuStatus');
    var CMStpgauge = Number(parameters['tpgauge'] || 0);
    var comwidth = 200; //コマンドウインドウの幅

    Window_Base.prototype.CMSdrawStatus = function(actor, x, y, width) { //新規
    var lineHeight = this.lineHeight();
    var x1 = x - 160; //顔の上にアクター名を描画する。
    var x2 = x + 8;
    var width2 = 108;
    this.drawActorName(actor, x1, y);
    this.drawActorLevel(actor, x1, y + lineHeight * 1);
    this.drawActorIcons(actor, x1, y + lineHeight * 2);
    this.drawActorClass(actor, x2, y);
    if(CMStpgauge == 0){ //TPゲージの描画可否
    this.drawActorHp(actor, x2, y + lineHeight * 1, width2);
    this.drawActorMp(actor, x2, y + lineHeight * 2, width2);
    }else{
    this.drawActorHp(actor, x2, y + lineHeight * 0.8, width2);
    this.drawActorMp(actor, x2, y + lineHeight * 1.6, width2);
    this.drawActorTp(actor, x2, y + lineHeight * 2.4, width2);
    }
    };

    Window_Gold.prototype.windowWidth = function() {
    return comwidth;
    };

    Window_MenuCommand.prototype.windowWidth = function() {
    return comwidth;
    };

    Window_MenuStatus.prototype.windowWidth = function() {
    return Graphics.boxWidth - comwidth; //幅はいただいた。
　　};

   Window_MenuStatus.prototype.maxCols = function() {
   return 2; //新規、列数を増やす。
   };

   Window_MenuStatus.prototype.drawItemStatus = function(index) {
   var actor = $gameParty.members()[index];
   var rect = this.itemRect(index);
   var x = rect.x + 162;
   var y = rect.y + rect.height / 2 - this.lineHeight() * 1.5;
   var width = rect.width - x - this.textPadding();
   this.CMSdrawStatus(actor, x, y, width); //新規の関数を呼び出す。
   };
         
})();
